%%% File 21 (479-610) -- complete
% KLG Updated 10/6/2011 for multiplatform



% SET GLOBAL VARIABLES
global eplanetorb meananom  % Sets global variables for findeccenanom function
global ATMLIMIT             % Set for rhotablebar.m function
global Kroll Bankhold
%%%%%%%%%%%%%%%%%% DEFAULT INITIAL SIMULATION CONDITION ARE SET BELOW %%%%%%%%%%%%%%%%%%%%%%%%%%%
% Default to zero density offset applied to standard atmosphere 
rhofactor = 1.0; %handl = findobj('Tag','rhofactor'); set(handl,'String',sprintf('%g',rhofactor));


% Set default simulation parameters % Path and file name 
%%% DEMO - changes made in the following "if" loop
if typeflag == 0,
    planetflag = 3; disp('Defaulted to Planet Earth');
    atmflag    = 2; disp('Defaulted to Table Look-up Interpolated Atmospheric Density');
    gravflag   = 2; disp('Defaulted to Inverse-Square Gravity Rotating Planet'); disp(' ');
    pname = ['Parameters' filesep 'Unguided_Params' filesep];
    fname = 'Earth_Landing_example';
elseif typeflag == 1,
    planetflag = 5; disp('Defaulted to Planet Mars');
    atmflag    = 2; disp('Defaulted to Table Look-up Interpolated Atmospheric Density');
    gravflag   = 2; disp('Defaulted to Inverse-Square Gravity Rotating Planet'); disp(' ');
    pname = ['Parameters' filesep 'Guided_Aerocapture_Params' filesep];
    fname = 'Mars_GAerocap_example';
elseif typeflag == 5,
    planetflag = 5; disp('Defaulted to Planet Mars');
    atmflag    = 2; disp('Defaulted to Table Look-up Interpolated Atmospheric Density');
    gravflag   = 2; disp('Defaulted to Inverse-Square Gravity Rotating Planet'); disp(' ');
    pname = ['Parameters' filesep 'Guided_Ballute_Params' filesep];
    fname = 'Mars_GBallute_example';
elseif typeflag == 6,
    planetflag = 2; disp('Defaulted to Planet Venus');
    atmflag    = 2; disp('Defaulted to Table Look-up Interpolated Atmospheric Density');
    gravflag   = 1; disp('Non-Rotating Atmospere'); disp(' ');
    pname = ['Parameters' filesep 'Aerobraking_Params' filesep];
    fname = 'Venus_Aerobrake_example';
elseif typeflag == 7,
    planetflag = 2; disp('Defaulted to Planet Venus');
    atmflag    = 2; disp('Defaulted to Table Look-up Interpolated Atmospheric Density');
    gravflag   = 1; disp('Non-Rotating Atmospere'); disp(' ');
    pname = ['Parameters' filesep 'Orbit_Decay_Params' filesep];
    fname = 'Venus_Decay_example';
    
end

atmflag = 2;

if planetflag == 2,
    planetvenus
    fname_atm  = 'Venus_ViraNight_short.mat';
    fname_atm2 = 'Venus_ViraNight_short';
    pname_atm  = ['Atmosphere' filesep 'Venus_Table' filesep];
    fname_exp  = 'VenusExp_default.mat';
    fname_exp2 = 'VenusExp_default';
    pname_exp  = ['Atmosphere' filesep 'Venus_Exp' filesep];
elseif planetflag == 3,
    planetearth         % KLG 1/7/2011 corrected
    fname_atm  = 'Earth_US1976.mat';
    fname_atm2 = 'Earth_US1976';
    pname_atm  = ['Atmosphere' filesep 'Earth_Table' filesep];
    fname_exp  = 'EarthExp_default.mat';
    fname_exp2 = 'EarthExp_default';
    pname_exp  = ['Atmosphere' filesep 'Earth_Exp' filesep];    
elseif planetflag == 5,
    planetmars
    fname_atm  = 'Mars_COS90_short.mat';
    fname_atm2 = 'Mars_COS90_short';
    pname_atm  = ['Atmosphere' filesep 'Mars_Table' filesep];
    fname_exp  = 'MarsExp_default.mat';
    fname_exp2 = 'MarsExp_default';
    pname_exp  = ['Atmosphere' filesep 'Mars_Exp' filesep];
end




%%%%%%%%%%%%%%%%%%%%% DEFINE FLAGS %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

grhosimflag 	= 0;	% set flag, see grhosims.m

% VIS FLAGS
ltflag			= 0;	% light flag, ambient light low, see lightcont.m
axisflag			= 0;	% axis flag, (u1,u2,u3) axis off, see axiscont.m
gridflag			= 1;	% grid flag, grid on, see gridcont.m
llflag			= 0;	% lat/long flag, lat long off, see llcont.m
amt 				= 5;	% GUI: default amount for up/down and left/right 
plantype			= 0;	% sphere or graphic, see planetemp.m

% PLOT CORRIDOR FLAGS
iap1even			= 0;	% set flag, see plotcor.m
iap1odd			= 0;	% set flag, see plotcor.m
iap2even			= 0;	% set flag, see plotcor.m
iap2odd			= 0;	% set flag, see plotcor.m

% MISC FLAGS 
scflag			= 0;	% see search.m, corridor.m and ballistic.m
exitflag			= 0;	% set flag, see ballistic.m
glflagld			= 0;	% set flag, see ballistic.m
spflagld			= 0;	% set flag, see ballistic.m
imflagld			= 0;	% set flag, see ballistic.m
glflaglu			= 0;	% set flag, see ballistic.m
spflaglu			= 0;	% set flag, see ballistic.m
imflaglu			= 0;	% set flag, see ballistic.m

% KRISTIN'S FLAGS & VALUES
vstop2      =   0;          %initialization--will be calculated later in program (grhosims[3])
vsimflag    =   0;          %always 0, except when searching for vstop in guided aerocapture function
vdiffflag   =   0;          %always 0, except when releasing ballute later in guided ballute function
vcor        =   10;         %default for vstop search accuracy (10 m/s)
maxg        =   100;        %will be set by user if necessary--defaulted high as not to interfere
srchaccflag =   2;          %default for fpa search accuracy (hundreths)
vehicleflag =   1;
svsimflag   =   0;
Vlevel      =   0;
Ventry      =   0;
Rinit       =   0;
circ_flag   =   0;      % Defaulted to no circularization manuever
asemistop    =   0;
cutball_flag = 0;
% timestep_flag = 0;
% ra          = 0;
%%% Default ballute values
ball_flag=0;       % Default no ballute added 
balltypeflag = 1;  % Default no type selected
target_flag = 0;
Adens_ballute = .2;
rad_ballute = 15;
d1_ballute = 15;
d2_ballute = 7;
m_ballute = 0;
CD_ballute = .9;
A_ballute = 550;
Rn_ballute = 15;
%%% Unguided Stop Condition defaults
maxaltstop  =   150000; % defaulted to 150 km
minaltstop  =   0;      % defaulted to 0 km
vstop2      =   10000;  % defaulted to 10 km/s
vstop       =   0;      
maxfpastop  =   90;
minfpastop  =   -90;
maxqdot     = 0.3;       % Defaulted to .3 W/cm^2
minqdot     = 0;
maxgload    =   20;
mingload    =   0;
targetstop  = maxaltstop+.000001;
time_ballcut = 0;
closeflag = 0;
Hp = 0;
ho = 0;


maxalt_flag     = 0;
minalt_flag     = 0;
maxspeed_flag   = 0;
minspeed_flag   = 0;
maxfpa_flag     = 0;
minfpa_flag     = 0;
maxheat_flag    = 0;   
minheat_flag    = 0;
maxgload_flag   = 0;
mingload_flag   = 0;
stopvec = [minalt_flag maxalt_flag minspeed_flag maxspeed_flag minfpa_flag maxfpa_flag mingload_flag maxgload_flag minheat_flag maxheat_flag];

%%% Other Default Values
aerobrake_flag  = 0;        % Needed
initv_flag      = 0;        % Defaulted to planet relative initial velocity
altitude_h      = 500000;   % Defaulted to 500 km
vo              = 8000;     % Defaulted to 8000 m/s
Period0         = 24;       % hours
%mu              = 4.2828e+013 % defaulted to mars
a0              = (((Period0*3600/(2*pi))^2)*mu)^(1/3);
initapo         = 2*a0 - 2*R-altitude_h;
ra_des          = 500000;   % Defaulted to 500 km
altitudeo       = 125000;   % Defaulted to 125 km
rpraise_alt     = 1000;     % Defaulted to 1 km
v_infin         = 8500;     % Defaulted to 8000 m/s

fname_untitled = 0;
fname_exp_untitled = 0;




% Default periapse altitude (km) for orbit function
%rp = 400;

% Default Julian Date of Arrival
% JD_arrival = 2453940.7916667; % Date of MSR Orbiter Arrival 2006 July 24



% Solar system data consolidated in this m-file
au = 1.495978e11;	   % (m) 1 astronomical unit, distance from Earth to sun ref. Orb Mechanics, Prussing
musun = 1.3271244e11*1e9 ;  % (m^3/s^2) Gravitational parameter of the sun fm Planetary Constants P8-2
univgas = 8.3143;      % Universal Gas Constant (J/mol-K)

% Reference Epochs
JD_1950 = 2433282.5;  % Julian Date from the 1950 reference Epoch (19500101)
JD_2000 = 2451545.0;  % Julian Date from the J2000 reference Epoch

% Set default guidance to no guidance
guidanceflag=1;       %Default guidance to open loop
guidance='openloop';   %Default guidance to open loop

% Set default simulation tolerances

abstol=1e-7;
reltol=1e-4;

% Set default value for stagnation heating coeficient 

C=6.36e-5;
Ktune=0;
Kroll=1;
bankhold=-1;

%  These are not used right now, but will initialize anyway

